// socket.js
const { winGoBetAdd, addWinGo, handlingWinGo1P, winGoGameHistory, winGoUserGameHistory } = require('../winGoController');
// import winGoController from '../winGoController';

const user_module = require('../../model/user_module');

function initSocket(io) {


    io.on('connection', (socket) => {
        console.log(`🔌 Client connected: ${socket.id}`);


        socket.on("userData", async (data) => {
            console.log('📩 Received userData:', data);

            const user =  await user_module.findById(data.userId);

            if (user) {
                socket.emit("userUpdatedData", { success: true, balance: user.balance });
            } else {  
                socket.emit("userUpdatedData", { success: false, message: "User not found" });
            }

        });



    //     console.log(`🔌 Client connected: ${socket.id}`);

    //     socket.on("join_game", (data) => {
    //          let join = 'wingo' + data.gameType;
    //         console.log(`🎮 ${socket.id} joined room: ${join}`);
    //         socket.join(join);

    //         // Optional: Notify the player
    //         // socket.emit("joined_room", { room: join });
    //         io.to(join).emit("joined_room", { new_join: socket.id });
    //     });

    //     socket.on('winGoBetPlace', async (data) => {
    //         winGoAdd(io, socket);
    //     })
    //     // socket.on('winGoBetPlace', async (data) => {
    //     //     winGoBetdd(io, socket);
    //     // })



    //     // cronJobGame1p(io, socket);
    //     // socket.on('new_message', (msg)=>{
    //     //     console.log(msg.msg);
    //     //     io.emit('new_user', msg.msg); 
    //     // });

    //     socket.on('disconnect', () => {
    //         console.log(`❌ Client disconnected: ${socket.id}`);
    //     });
    });




    function switchRoom(socket, newRoom) {
        // Leave all rooms except the private socket room
        for (let room of socket.rooms) {
            if (room !== socket.id) {
                socket.leave(room);
                console.log(`${socket.id} left room: ${room}`);
            }
        }

        // Join the new room
        socket.join(newRoom);
        console.log(`${socket.id} joined room: ${newRoom}`);
    }




    io.on('connection', (socket) => {
        console.log(`🔌 Client connected: ${socket.id}`);
        // socket.on("join_game", (data) => {
        //     let join = 'wingo' + data.gameType;
        //     console.log(`🎮 ${socket.id} joined room: ${join}`);
        //     socket.join(join);

        //     io.to(join).emit("joined_room", { new_join: socket.id });
        // });
        socket.on("join_room", (data) => {
            const roomName = `wingo${data.gameType}`;
            switchRoom(socket, roomName);
        });


        // socket.on("check_room", (data) => {
        //     let join = 'wingo' + data.gameType;
        //     if (socket.rooms.has(join)) {
        //         console.log(`✅ ${socket.id} is already in room: ${join}`);
        //     } else {
        //         console.log(`❌ ${socket.id} is NOT in room: ${join}`);
        //     }
        //     io.to(join).emit("roomlist", { list: socket.rooms });
        // });


        socket.on('winGoBetPlace', async (data) => {
            winGoBetAdd(data, io, socket);
        });


        socket.on('winGoGameHistory', async (data) => {

            winGoGameHistory(data, io, socket);
        });

        socket.on('winGoUserGameHistory', async (data) => {

            winGoUserGameHistory(data, io, socket);
        });


        socket.on('disconnect', () => {
            console.log(`❌ Client disconnected: ${socket.id}`);
        });
    });
}

module.exports = { initSocket };
