//controller/winGoController.js

const UserModule = require('../model/user_module');
const WinGoModule = require('../model/winGo_module');
const AdmineSetResultModule = require('../model/admin_set_result');
const WinGoBetResult_module = require('../model/winGoBetResult_module');

const winGoBetAdd = async (data, io, socket) => {
    try {
        console.log(`🎉 socket call winGoBetPlace`, data);
        let join = 'wingo' + data.gameType;


        const betMapping = {
            l: "size_big",   // large
            n: "size_small", // small
            d: "color_red",
            x: "color_green",
            t: "color_violet",
            "0": "no_0",
            "1": "no_1",
            "2": "no_2",
            "3": "no_3",
            "4": "no_4",
            "5": "no_5",
            "6": "no_6",
            "7": "no_7",
            "8": "no_8",
            "9": "no_9"
        };

        // Get admin multipliers
        const rewardMultiplier = await AdmineSetResultModule.findOne();

        // find key for bet
        const betKey = betMapping[data.bet];

        if (!betKey) {
            socket.emit('error', 'Invalid bet option');
            return;
        }

        // get multiplier
        const multiplier = rewardMultiplier[betKey] ? parseFloat(rewardMultiplier[betKey]) : 1;

        console.log(`(((((((()))))) ~ winGoController.js:59 ~ winGo ~ rewardMultiplier[betKey]:`, rewardMultiplier[betKey]);

        console.log(`(((((((()))))) ~ winGoController.js:29 ~ winGo ~ rewardMultiplier:`, multiplier);


        let winGoNow = await WinGoModule.findOne({ game: join, status: 0 });

        if (!winGoNow) {
            io.to(join).emit('error', 'No ongoing Wingo round found.');
        }

        const winGoPeriod = winGoNow?.period;

        console.log(`(((((((()))))) ~ winGoController.js:69 ~ winGoBetAdd ~ winGoPeriod:`, winGoPeriod);



        const money = parseInt(data.money) * data.amount - (parseInt(data.money) * data.amount * 0.02);
        const fee = parseInt(data.money) * data.amount * 0.02;
        const winMoney = parseInt(data.money) * data.amount * 0.02 * multiplier;


        const betPlaceAdminData = {};

        data.bet == 'd' ? betPlaceAdminData.joinRed = money : '';
        data.bet == 'x' ? betPlaceAdminData.joinGreen = money : '';
        data.bet == 't' ? betPlaceAdminData.joinViolet = money : '';

        data.bet == '0' ? betPlaceAdminData.join0 = money : '';
        data.bet == '1' ? betPlaceAdminData.join1 = money : '';
        data.bet == '2' ? betPlaceAdminData.join2 = money : '';
        data.bet == '3' ? betPlaceAdminData.join3 = money : '';
        data.bet == '4' ? betPlaceAdminData.join4 = money : '';
        data.bet == '5' ? betPlaceAdminData.join5 = money : '';
        data.bet == '6' ? betPlaceAdminData.join6 = money : '';
        data.bet == '7' ? betPlaceAdminData.join7 = money : '';
        data.bet == '8' ? betPlaceAdminData.join8 = money : '';
        data.bet == '9' ? betPlaceAdminData.join9 = money : '';

        data.bet == 'l' ? betPlaceAdminData.joinBig = money : '';
        data.bet == 'n' ? betPlaceAdminData.joinSmall = money : '';


        // data.bet == 'd' ? betPlaceAdminData.joinRed = data.amount : betPlaceAdminData.joinRed = 0;
        // data.bet == 'x' ? betPlaceAdminData.joinGreen = data.amount :betPlaceAdminData.joinGreen = 0;
        // data.bet == 't' ? betPlaceAdminData.joinViolet = data.amount : betPlaceAdminData.joinViolet = 0;

        // data.bet == '0' ? betPlaceAdminData.join0 = data.amount : betPlaceAdminData.join0 = 0;
        // data.bet == '1' ? betPlaceAdminData.join1 = data.amount : betPlaceAdminData.join1 = 0;
        // data.bet == '2' ? betPlaceAdminData.join2 = data.amount : betPlaceAdminData.join2 = 0;
        // data.bet == '3' ? betPlaceAdminData.join3 = data.amount : betPlaceAdminData.join3 = 0;
        // data.bet == '4' ? betPlaceAdminData.join4 = data.amount : betPlaceAdminData.join4 = 0;
        // data.bet == '5' ? betPlaceAdminData.join5 = data.amount : betPlaceAdminData.join5 = 0;
        // data.bet == '6' ? betPlaceAdminData.join6 = data.amount : betPlaceAdminData.join6 = 0;
        // data.bet == '7' ? betPlaceAdminData.join7 = data.amount : betPlaceAdminData.join7 = 0;
        // data.bet == '8' ? betPlaceAdminData.join8 = data.amount : betPlaceAdminData.join8 = 0;
        // data.bet == '9' ? betPlaceAdminData.join9 = data.amount : betPlaceAdminData.join9 = 0;

        // data.bet == 'l' ? betPlaceAdminData.joinBig = data.amount : betPlaceAdminData.joinBig = 0;
        // data.bet == 'n' ? betPlaceAdminData.joinSmall = data.amount : betPlaceAdminData.joinSmall = 0;


        const addWinGoBet = await WinGoBetResult_module.create({
            period: winGoPeriod,
            phone: data.phone,
            game: join,
            bet: data.bet,
            money,
            fee,
            winMoney: money * multiplier,
            amount: data.amount,
        });


        // console.log(`(((((((()))))) ~ winGoController.js:102 ~ winGoBetAdd ~ betPlaceAdminData:`, betPlaceAdminData);

        io.to(join).emit('betPlaceAdminData', betPlaceAdminData);

        socket.emit('betPlace', addWinGoBet);


    } catch (error) {
        console.log("nknk", error);
    }
}


const addWinGo = async ({ gameType, io }) => {
    try {
        console.log('addWinGo called', gameType);
        //    io.to("wingo30").emit('winnerDeclare', '--------winnerDeclareres-------------');

        function getPeriodId() {
            const now = new Date();
            const year = now.getFullYear();
            const month = String(now.getMonth() + 1).padStart(2, '0'); // months are 0-indexed
            const day = String(now.getDate()).padStart(2, '0');

            return `${year}${month}${day}`;
        }

        const timeNow_period = getPeriodId();
        const timeNow = Date.now();

        // console.log(`(((((((()))))) ~ winGoController.js:23 ~ addWinGo ~ timeNow:`, timeNow);
        let join = 'wingo' + gameType;

        if (!join) {
            console.log('Invalid gameType');
        }

        // Update or insert Wingo result
        let winGoNow = await WinGoModule.findOne({ game: join }).sort({ createdAt: -1 });


        if (!winGoNow) {
            console.log('No game found');
            const setPeriodtimeNow = timeNow_period + '000000000';

            await WinGoModule.create({ period: parseInt(setPeriodtimeNow), result: 0, game: join, status: 0, time: timeNow });
            winGoNow = await WinGoModule.findOne({ game: join }).sort({ createdAt: -1 });
            console.log("winGoNow winGoNow", winGoNow);
        } else {

            const setting = await AdmineSetResultModule.find();

            if (!setting.length) {
                console.log('No admin setting found');
            }

            let period = winGoNow.period;

            console.log(`addWinGo ~ period:`, period);

            let nextperiod = (BigInt(period) + BigInt(1)).toString();

            console.log(`addWinGo ~ nextperiod:`, nextperiod);

            let result = Math.floor(Math.random() * 10);

            let minPlayers = await WinGoBetResult_module.find({ period, game: join, status: 0 });

            const totalBetAmount = minPlayers.reduce((acc, player) => acc + player.money, 0);

            console.log(`(((((((()))))) ~ winGoController.js:161 ~ addWinGo ~ totalBetAmount:`, totalBetAmount);

            let sqlHitCount = 0;

            if (minPlayers.length != 0) {

                console.log('more then 0 players');

                const betColumns = [
                    { name: 'red_0', bets: ['0', 't', 'd', 'n'] },

                    { name: 'red_2', bets: ['2', 'd', 'n'] },

                    { name: 'red_4', bets: ['4', 'd', 'n'] },

                    // green small 

                    { name: 'green_1', bets: ['1', 'x', 'n'] },

                    { name: 'green_3', bets: ['3', 'x', 'n'] },

                    // green big 

                    { name: 'green_5', bets: ['5', 'x', 't', 'l'] },

                    { name: 'green_7', bets: ['7', 'x', 'l'] },

                    { name: 'green_9', bets: ['9', 'x', 'l'] },

                    // red big 

                    { name: 'red_6', bets: ['6', 'd', 'l'] },

                    { name: 'red_8', bets: ['8', 'd', 'l'] }
                ];

                // Calculate total bet money per column
                const totals = await Promise.all(
                    betColumns.map(async column => {
                        const resultData = await WinGoBetResult_module.aggregate([
                            { $match: { game: join, period, status: 0, bet: { $in: column.bets } } },
                            { $group: { _id: null, total_money: { $sum: "$money" }, total_winMoney: { $sum: "$winMoney" } } }
                        ]);

                        return {
                            name: column.name,
                            total_money: resultData.length ? resultData[0].total_money : 0,
                            total_winMoney: resultData.length ? resultData[0].total_winMoney : 0
                        };
                    })
                );

                console.log(`(((((((()))))) ~ winGoController.js:150 ~ addWinGo ~ totals:`, totals);

                function shuffleArray(array) {
                    const shuffled = array.slice();
                    for (let i = shuffled.length - 1; i > 0; i--) {
                        const j = Math.floor(Math.random() * (i + 1));
                        [shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]];
                    }
                    return shuffled;
                }

                categories = shuffleArray(totals);

                // const filtedCategories = categories.filter(category => category.total_money > 0);
                let filtedCategories = categories.filter(category => category.total_winMoney > 0);
                // console.log("💰 shuffleArray:", filtedCategories);

                let smallestCategory = filtedCategories.reduce((smallest, category) =>
                    (smallest === null || category.total_winMoney < smallest.total_winMoney) ? category : smallest
                    , null);

                console.log(`old ~ smallestCategory:`, smallestCategory);

                if (totalBetAmount < smallestCategory.total_winMoney) {

                    console.log('totalBetAmount < smallestCategory.total_winMoney');
                    filtedCategories = categories.filter(category => category.total_winMoney > 0);
                    // console.log("💰 shuffleArray:", filtedCategories);

                    smallestCategory = categories.reduce((smallest, category) =>

                        (smallest === null || category.total_winMoney < smallest.total_winMoney)
                            ?
                            category
                            :
                            smallest, null

                    );
                }

                console.log(`new smallestCategory:`, smallestCategory);

                const colorBets = {

                    red_6: [6],

                    red_8: [8],

                    red_2: [2], //0 removed 

                    red_4: [4],

                    green_3: [3],

                    green_7: [7], //5 removed

                    green_9: [9], //

                    green_1: [1],

                    green_5: [5],

                    red_0: [0],

                };

                const betsForCategory = colorBets[smallestCategory.name] || [];

                const availableBets = betsForCategory.filter(bet =>

                    !filtedCategories.find(category => category.name === smallestCategory.name && category.total_winMoney < smallestCategory.total_winMoney)

                );
                console.log("availableBets", availableBets);

                let lowestBet;

                //  console.log(`(((((((()))))) ~ winGoController.js:208 ~ addWinGo ~ lowestBet:`, lowestBet);

                if (availableBets.length > 0) {

                    lowestBet = availableBets[0];

                } else {

                    lowestBet = betsForCategory.reduce((lowest, bet) =>

                        (bet < lowest) ? bet : lowest

                    );

                }

                result = lowestBet;

                const winner = betColumns.filter(betColumn => betColumn.name === smallestCategory.name);

                // console.log(`(((((((()))))) ~ winGoController.js:228 ~ addWinGo ~ winner:`, winner);

                const winnerUpdate = await Promise.all(
                    minPlayers.map(async (player) => {
                        if (winner[0].bets.includes(player.bet)) {
                            player.status = "1";


                        } else {
                            player.status = "2";
                        }
                        return player.save();
                    })
                );

                console.log("🚀 ~result:", result)
                // console.log("🚀 ~ winnerUpdate:", winnerUpdate)
            }
            // else if (minPlayers.length === 1 && parseFloat(minPlayers[0].money) >= 20) {

            //     console.log(" for one player");

            //     const betColumns = [

            //         { name: 'red_small', bets: ['0', '2', '4', 'd', 'n'] },

            //         { name: 'red_big', bets: ['6', '8', 'd', 'l'] },

            //         { name: 'green_big', bets: ['5', '7', '9', 'x', 'l'] },

            //         { name: 'green_small', bets: ['1', '3', 'x', 'n'] },

            //         { name: 'violet_small', bets: ['0', 't', 'n'] },

            //         { name: 'violet_big', bets: ['5', 't', 'l'] }

            //     ];

            //     const categories = await Promise.all(betColumns.map(async column => {

            //         const resultData = await WinGoBetResult_module.aggregate([
            //             { $match: { game: join, status: 0, bet: { $in: column.bets } } },
            //             { $group: { _id: null, total_money: { $sum: "$money" } } }
            //         ]);

            //         return {
            //             name: column.name,
            //             total_money: resultData.length ? resultData[ 0 ].total_money : 0
            //         }

            //     }));


            //     const colorBets = {

            //         red_big: [6, 8],

            //         red_small: [2, 4], //0 removed 

            //         green_big: [7, 9], //5 removed

            //         green_small: [1, 3],

            //         violet_big: [5],

            //         violet_small: [0],

            //     };

            //     const smallestCategory = categories.reduce((smallest, category) =>

            //         (!smallest || category.total_money < smallest.total_money) ? category : smallest

            //     );



            //     const betsForCategory = colorBets[smallestCategory.name] || [];

            //     const availableBets = betsForCategory.filter(bet =>

            //         !categories.find(category => category.name === smallestCategory.name && category.total_money < smallestCategory.total_money)

            //     );

            //     const lowestBet = availableBets.length > 0 ? availableBets[0] : Math.min(...betsForCategory);

            //     result = lowestBet;
            // }




            let nextResult = '';

            if (gameType == 30) nextResult = setting[0].wingo.wingo30;

            if (gameType == 1) nextResult = setting[0].wingo.wingo1;

            if (gameType == 3) nextResult = setting[0].wingo.wingo3;

            if (gameType == 5) nextResult = setting[0].wingo.wingo5;

            if (gameType == 10) nextResult = setting[0].wingo.wingo10;

            let newArr = '';

            console.log(`(((((((()))))) ~ winGoController.js:302 ~ addWinGo ~ nextResult:`, result);

            const betPlaceAdminData = {};

            betPlaceAdminData.joinRed = 0;
            betPlaceAdminData.joinGreen = 0;
            betPlaceAdminData.joinViolet = 0;

            betPlaceAdminData.join0 = 0;
            betPlaceAdminData.join1 = 0;
            betPlaceAdminData.join2 = 0;
            betPlaceAdminData.join3 = 0;
            betPlaceAdminData.join4 = 0;
            betPlaceAdminData.join5 = 0;
            betPlaceAdminData.join6 = 0;
            betPlaceAdminData.join7 = 0;
            betPlaceAdminData.join8 = 0;
            betPlaceAdminData.join9 = 0;

            betPlaceAdminData.joinBig = 0;
            betPlaceAdminData.joinSmall = 0;

            betPlaceAdminData.totalBetAmount = 0;




            console.log(`(((((((()))))) ~ winGoController.js:473 ~ addWinGo ~ nextResult:`, nextResult);
            if (nextResult == '-1') {
                console.log(`(((((((()))))) ~ winGoController.js:477 ~ addWinGo ~ period:`, period);
                const winGoResultUpdate = await WinGoModule.findOneAndUpdate({ period }, { result, status: 1 }, { new: true });

                newArr = '-1';
                io.to(join).emit('winnerDeclare', { period, winner: result, winGoResultUpdate });
                io.to(join).emit('betPlaceAdminData', betPlaceAdminData);
            }
            else {
                let result = '';
                let arr = nextResult.split('|');
                let check = arr.length;

                if (check == 1) {
                    newArr = '-1';
                } else {
                    for (let i = 1; i < arr.length; i++) {
                        newArr += arr[i] + '|';
                    }
                    newArr = newArr.slice(0, -1);
                }

                result = arr[0];

                console.log(`(((((((()))))) ~ winGoController.js:302 ~ addWinGo ~ result:`, result);

                const winGoResultUpdate = await WinGoModule.findOneAndUpdate({ period }, { result, status: 1 }, { new: true });
                newArr = '-1';

                io.to(join).emit('winnerDeclare', { period, winner: result, winGoResultUpdate });
                io.to(join).emit('betPlaceAdminData', betPlaceAdminData);
            }
            // console.log(`(((((((()))))) ~ winGoController.js:308 ~ addWinGo ~ nextperiod:`, nextperiod);

            const insertWinGo = await WinGoModule.create({ period: nextperiod, result: 0, game: join, status: 0, time: timeNow });


            // console.log(`(((((((()))))) ~ winGoController.js:315 ~ addWinGo ~ insertWinGo:`, insertWinGo);

            if (join == 'wingo30') { await AdmineSetResultModule.findOneAndUpdate({}, { $set: { 'wingo.wingo30': newArr } }, { new: true }); }
            if (join == 'wingo1') { await AdmineSetResultModule.findOneAndUpdate({}, { $set: { 'wingo.wingo1': newArr } }, { new: true }); }
            if (join == 'wingo3') { await AdmineSetResultModule.findOneAndUpdate({}, { $set: { 'wingo.wingo3': newArr } }, { new: true }); }
            if (join == 'wingo5') { await AdmineSetResultModule.findOneAndUpdate({}, { $set: { 'wingo.wingo5': newArr } }, { new: true }); }
            if (join == 'wingo10') { await AdmineSetResultModule.findOneAndUpdate({}, { $set: { 'wingo.wingo10': newArr } }, { new: true }); }
        }

    } catch (err) {
        console.error('❌ Error adding Wingo:', err);
        // socket.emit('error', { message: 'Failed to add Wingo' });
    }
}

const handlingWinGo1P = async (gameType) => {
    console.log(gameType);
    console.log('handlingWinGo1P test');
}

const winGoGameHistory = async (data, io, socket) => {
    const join = 'wingo' + data.gameType;
    const page = data.page || 1;
    const limit = data.limit || 10;
    const skip = (page - 1) * limit;
    console.log('gameType');
    console.log('winGoGameHistory test');


    try {
        const winGoGameHistoryList = await WinGoModule.find({ game: join, status: 1 }).skip(skip).limit(limit).sort({ createdAt: -1 }).lean();
        console.log(`(((((((()))))) ~ winGoController.js:302 ~ addWinGo ~ winGo30:`, winGoGameHistoryList);
        const historyWithPagination = {
            winGoGameHistoryList,
            currentPage: page,
            totalPages: Math.ceil(await WinGoModule.countDocuments({ game: join, status: 1 }) / limit),
        }
        io.to(join).emit('winGoGameHistory', historyWithPagination);
    } catch (err) {
        console.log(err);
        io.to(join).emit('error', { message: 'Failed to add Wingo game history' });
    }

}
const winGoUserGameHistory = async (data, io, socket) => {
    const join = 'wingo' + data?.gameType;
    const page = data?.page || 1;
    const limit = data?.limit || 10;
    const skip = (page - 1) * limit;
    const phone = data?.phone;

    console.log('gameType');
    console.log('winGoUserGameHistory test');


    try {
        const winGoUserHistoryList = await WinGoBetResult_module.find({ game: join, phone }).skip(skip).limit(limit).sort({ createdAt: -1 }).lean();
        console.log(`(((((((()))))) ~ winGoController.js:302 ~ addWinGo ~ winGo30:`, winGoUserHistoryList);
        const userGameHistoryWithPagination = {
            winGoUserHistoryList,
            currentPage: page,
            totalPages: Math.ceil(await WinGoBetResult_module.countDocuments({ game: join, phone }) / limit),
        }
        io.to(join).emit('winGoUserHistory', userGameHistoryWithPagination);

    } catch (err) {
        console.log(err);
        io.to(join).emit('error', { message: 'Failed to add Wingo game history' });
    }

}

module.exports = { winGoBetAdd, addWinGo, handlingWinGo1P, winGoGameHistory, winGoUserGameHistory };