const sendFireBaseNotification = async (token, title, body) => {
    const message = {
        token: token,
        notification: {
            title: title,
            body: body,
        },
        android: {
            notification: {
                icon: "ic_notification",   // your custom icon
                color: "#ffffff"
            }
        }
    };

    try {
        const response = await admin.messaging().send(message);
        return response;
    } catch (error) {
        console.error("Error sending notification:", error);
    }
};