// const multer = require('multer');
// const path = require('path');

// // Use memory storage to get files as Buffer
// const storage = multer.memoryStorage();

// // File filter (allow only images)
// const fileFilter = (req, file, cb) => {
//     const allowedTypes = /jpeg|jpg|png|gif/;
//     const extname = allowedTypes.test(path.extname(file.originalname).toLowerCase());
//     const mimetype = allowedTypes.test(file.mimetype);
    
//     if (mimetype && extname) {
//         cb(null, true);
//     } else {
//         cb(new Error('Invalid file type. Only images are allowed'), false);
//     }
// };

// const upload = multer({
//     storage: storage, // This stores files in memory as Buffer
//     limits: {
//         fileSize: 5 * 1024 * 1024 // 5MB limit
//     },
//     fileFilter: fileFilter
// });

// console.log(`(((((((()))))) ~ handleFileUpdate.js:28 ~ upload:`, upload);

// module.exports = upload;








const multer = require('multer');
const path = require('path');

// File storage setup
// const storage = multer.diskStorage({
//     destination: (req, file, cb) => {
//         cb(null, 'uploads/slips/file/');
//     },
//     filename: (req, file, cb) => {
//         const ext = path.extname(file.originalname);
//         const filename = `slip_${Date.now()}${ext}`;
//         cb(null, filename);
//     }
// });

const storage = multer.memoryStorage();

// File filter (allow only jpg, jpeg, png)
const fileFilter = (req, file, cb) => {
    const allowedTypes = /jpeg|jpg|png/;
    const extname = allowedTypes.test(path.extname(file.originalname).toLowerCase());
    if (extname) {
        cb(null, true);
    } else {
        cb(new Error('Invalid file type'), false);
    }
};

const upload = multer({ storage, fileFilter });

module.exports = upload;
