const mongoose = require('mongoose');


const dollarBazarSchema = new mongoose.Schema({
    gatewayId: {
        type: String,
        default: 'dollar_bazar',
        unique: true
    },
    name: {
        type: String,
        default: 'Dollar Bazar'
    },
    status: {
        type: Boolean,
        default: false
    },
    
    // REMOVE THESE OLD FIELDS:
    // apiKey: String,
    // clientId: String,
    // secretKey: String, // ← REMOVE
    // salt: String,
    // baseUrl: String,
    
    // ADD THESE NEW FIELDS:
    // PayIn Credentials
    payinApiKey: String,
    payinSalt: String,
    payinClientId: String,
    payinBaseUrl: {
        type: String,
        default: 'https://collect.dollarbazar.co'
    },
    
    // Payout Credentials
    payoutApiKey: String,
    payoutSalt: String,
    payoutClientId: String,
    payoutBaseUrl: {
        type: String,
        default: 'https://payout.dollarbazar.co'
    },
    
    // Keep these
    minAmount: {
        type: Number,
        default: 100
    },
    maxAmount: {
        type: Number,
        default: 50000
    },
    processingFee: {
        type: Number,
        default: 0
    },
    // REMOVE testMode field
}, {
    timestamps: true
});









// const dollarBazarSchema = new mongoose.Schema({
//     gatewayId: {
//         type: String,
//         default: 'dollar_bazar',
//         unique: true
//     },
//     name: {
//         type: String,
//         default: 'Dollar Bazar'
//     },
//     status: {
//         type: Boolean,
//         default: false
//     },
//     apiKey: String,
//     clientId: String,
//     secretKey: String,
//     salt: String,
//     baseUrl: {
//         type: String,
//         default: 'https://collect.dollarbazar.co'
//     },
//     minAmount: {
//         type: Number,
//         default: 100
//     },
//     maxAmount: {
//         type: Number,
//         default: 50000
//     },
//     processingFee: {
//         type: Number,
//         default: 2
//     },
//     testMode: {
//         type: Boolean,
//         default: true
//     },
//     insert_date: {
//         type: Date,
//         default: Date.now,
//     },
// }, {
//     timestamps: true
// });

module.exports = mongoose.model('DollarBazarSettings', dollarBazarSchema);