const mongoose = require('mongoose');


const protonPaySchema = new mongoose.Schema({
    gatewayId: {
        type: String,
        default: 'proton_pay',
        unique: true
    },
    name: {
        type: String,
        default: 'Proton Pay'
    },
    status: {
        type: Boolean,
        default: false
    },

    // API Credentials
    apiKey: String, // X-Key
    merchantCode: String,
    merchantKey: String,

    // URLs
    baseUrl: {
        type: String,
        default: 'https://api.protonpay.io'
    },
    returnUrl: String,
    notifyUrl: String,

    // Limits (in rupees)
    minPayin: {
        type: Number,
        default: 0
    },
    maxPayin: {
        type: Number,
        default: 0
    }
}, {
    timestamps: true
});




module.exports = mongoose.model('ProtonPaySettings', protonPaySchema);


// const protonPaySchema = new mongoose.Schema({
//     gatewayId: {
//         type: String,
//         default: 'proton_pay',
//         unique: true
//     },
//     name: {
//         type: String,
//         default: 'Proton Pay'
//     },
//     status: {
//         type: Boolean,
//         default: false
//     },
//     apiKey: String,
//     secretKey: String,
//     merchantId: String,
//     baseUrl: {
//         type: String,
//         default: 'https://api.protonpay.com'
//     },
//     minAmount: {
//         type: Number,
//         default: 100
//     },
//     maxAmount: {
//         type: Number,
//         default: 50000
//     },
//     processingFee: {
//         type: Number,
//         default: 2
//     },
//     testMode: {
//         type: Boolean,
//         default: true
//     },
//     insert_date: {
//         type: Date,
//         default: Date.now,
//     },
// }, {
//     timestamps: true
// });