const mongoose = require('mongoose');

const add_funds_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    amount: {
        type: Number,
        required: true,
    },
    // file_path:{
    //     type : String,
    //     required : true
    // },
    // fund_payment_receipt: {
    //     type : String,
    //     required : true
    // },
    fund_status: {
        type: Number,
        default: 0, // 0 = pending , 1 = approve , 2 = rejected
    },
    tx_request_number: {
        type: String, // unique id generated when user add fund request created and order id for payment gateway and webhook
        required: true,
    },
    txn_ref: {
        type: String,  // transaction id from payment gateway
    },
    bankReference: {
        type: String, // bank reference from webhook callback
    },
    payment_method: {
        type: String,
    },
    deposit_type: {
        type: Number,
        required: true, // 0 = manual , 1 = automatic
    },
    reject_remark: {
        type: String,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const add_funds_module = mongoose.model('add_funds', add_funds_schema);

module.exports = add_funds_module;