const mongoose = require('mongoose');

const app_link_schema = new mongoose.Schema({
    app_link: {
        type: String,
        required: true,
    },
    change_logs: {
        type: String,
        required: true,
    },
    content: {
        type: String,
        required: true,
    },
    version: {
        type: String,
        required: true,
    },
    status: {
        type: Number,
        default: 0,
    },

}, { timestamps: true });

const app_link_module = mongoose.model('app_link', app_link_schema);

module.exports = app_link_module;