const mongoose = require('mongoose');

const app_settingSchema = new mongoose.Schema({
    user_current_version: {
        type: String,
        required: true,
    },
    user_minimum_version: {
        type: String,
        required: true,
    },
    pop_status: {
        type: Number,
        required: true,
    },
    message: {
        type: String,
        required: true,
    },
    message_hindi: {
        type: String,
        required: true,
    },
    link: {
        type: String,
        required: true,
    },
    link_btn_text: {
        type: String,
        required: true,
    },
    action_type: {
        type: Number,
        required: true,
    },
    action_btn_text: {
        type: String,
        required: true,
    },

    
    app_date: {
        type: Date,
        default: Date.now
    },
});

const app_setting_module = mongoose.model('app_setting', app_settingSchema);

module.exports = app_setting_module;