const mongoose = require('mongoose');

const bid_archive_history_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    gameDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'games'
    },
    game_name: {
        type: String,
        required: true,
    },
    pana: {
        type: String,
        required: true,
    },
    session: {
        type: String,
        // required: true,
    },
    digits: {
        type: String,
        required: true,
    },
    winning_points: {
        type: Number,
        required: true,
    },
    closedigits: {
        type: String,
    },
    points: {
        type: Number,
        required: true,
    },
    bid_tx_id: {
        type: String,
        required: true,
    },
    status: {
        type: Number,
        default: 1,
    },
    pay_status: {
        type: Number,
        required: true, // 1 = win , 2 = lose , 0 = pending , 3 = Cancel
    },
    open_result_token: {
        type: String,
    },
    close_result_token: {
        type: String,
    },
    bid_date: {
        type: Date,
        required: true,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
},
    {
        timestamps: true,
    });

const bid_archive_history_module = mongoose.model('bid_archive_history', bid_archive_history_schema);

module.exports = bid_archive_history_module;