const mongoose = require('mongoose');

const chat_msg_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    ticket_id: {
        type: Number,
        required: true,
    },
    support_id: {
        type: Number,
        required: true,
    },
    reply: {
        type: String,
        required: true,
    },
    file: {
        type: mongoose.Schema.Types.ObjectId,
        ref: "file",
        require: true
    },
    reply_type: {
        type: Number,
        required: true,
    },

    
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const chat_msg_module = mongoose.model('chat_msg', chat_msg_schema);

module.exports = chat_msg_module;