const mongoose = require('mongoose');

const gamecontentRuleSchema = new mongoose.Schema({
  videos: {
    type: String,
    default: ''
  },
  gameRules: {
    type: String,
    default: ""
  },
  withdrawRules: {
    type: String,
    default: ""
  },
  depositRules: {
    type: String,
    default: ""
  },
  homeRules: {
    type: String,
    default: ""
  }
}, {
  timestamps: true
});

// Create a singleton document
gamecontentRuleSchema.statics.getContent = async function () {
  let content = await this.findOne();
  if (!content) {
    content = await this.create({});
  }
  return content;
};

module.exports = mongoose.model('game_content_rules', gamecontentRuleSchema);