const mongoose = require('mongoose');

const district_schema = new mongoose.Schema({
    stateDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'state',
        required: true,
    },
    district_name: {
        type: String,
        required: true,
    },
    status: {
        type: Number,
        default: 1,
    },
    order_district: {
        type: Number,
        default: 0,
    },

    
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const district_module = mongoose.model('district', district_schema);

module.exports = district_module;