const mongoose = require('mongoose');

const fileSchema = new mongoose.Schema({
    filename: { type: String, required: true },   // original file name
    mimetype: { type: String, required: true },   // image/png, image/jpeg etc.
    size: { type: Number, required: true },       // in bytes
    buffer: { type: Buffer, required: true },     // 🔥 file stored in Mongo
    uploadedBy: { type: mongoose.Schema.Types.ObjectId, ref: 'Admin' },
    uploadedAt: { type: Date, default: Date.now }
});

module.exports = mongoose.model('File', fileSchema);




// const mongoose = require('mongoose');

// const file_schema = new mongoose.Schema({
//     fileInfo: {
//         require: true,
//         type: {
//             fileBuffer: {
//                 type: Buffer,
//                 require: true
//             },
//             content_type: {
//                 type: String,
//                 require: true
//             }
//         }
//     },
// });

// const file_module = mongoose.model('file', file_schema);

// module.exports = file_module;