const mongoose = require('mongoose');

const fix_values_schema = new mongoose.Schema({
    app_id: {
        type: Number,
        required: true,
        default: 1
    },
    min_deposite: {
        type: Number,
        default: 10
    },
    max_deposite: {
        type: Number,
        default: 2000
    },
    min_withdrawal: {
        type: Number,
        default: 10
    },
    max_withdrawal: {
        type: Number,
        default: 2000
    },
    withdrawLimit: {
        type: Number,
        default: 4
    },
    withdrawLimitChangeRemark: {
        type: String,
        default: "Initial setup"
    },
    min_transfer: {
        type: Number,
        default: 50
    },
    max_transfer: {
        type: Number,
        default: 10000
    },
    min_bid_amount: {
        type: Number,
        default: 10
    },
    max_bid_amount: {
        type: Number,
        default: 50000
    },
    welcome_bonus: {
        type: Number,
        default: 20
    },
    global_batting_status: {
        type: Number,
        default: 0
    },
    app_maintainence_msg: {
        type: String,
        default: "We are working on this page, please try again after"
    },
    maintainence_msg_status: {
        type: Number,
        default: 0
    },
    marquee: {
        type: String,
        default: "Welcome on AL786 !"
    },
    user_refer_bonus: {
        type: Number,
        default: 2
    },
    agent_refer_bonus: {
        type: Number,
        default: 10
    },
    withdraw_open_time: {
        type: String,
        default: "12:30"
    },
    withdraw_close_time: {
        type: String,
        default: "03:30"
    },
    // New fields for additional settings
    homescreen_text: {
        type: String,
        default: "THIS IS A DEMO APP, DO NOT DEPOSIT ANY MONEY"
    },
    refer_reward_status: {
        type: Number,
        default: 1
    },
    refer_self_reward: {
        type: Number,
        default: 8
    },
    refer_new_user_reward: {
        type: Number,
        default: 10
    },
    starline_enable: {
        type: Number,
        default: 1
    },
    delhi_enable: {
        type: Number,
        default: 1
    },
    share_link: {
        type: String,
        default: "https://google.com"
    },
    withdraw_video_link: {
        type: String,
        default: "-"
    },
    archive_history_days: {
        type: Number,
        default: 30
    },
    userManualPaymentMode: {
        type: Number,
        default: 0          // 0 = manual payment not active , and 1 = manual payment active
    },
    userPgPaymentMode: {
        type: Number,
        default: 0           // 0 = PG payment not active , and 1 = PG payment active
    },
    autoWithdrawalStatus: {
        type: Number,
        default: 0           // 0 = disable the auto withdraw approval functionality, and 1 = active/ enable the auto withdraw approval functionality
    },
    autoWithdrawPgType: {
        type: Number,
        default: 7           // 7 = Dollar Bazar, 8 = Proton Pay
    },
    autoWithdrawalMinAmount: {
        type: Number,
        default: 0           // min amount for auto withdrawal
    },
    autoWithdrawalMaxAmount: {
        type: Number,
        default: 0           // Max amount for auto withdrawal
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const fix_values_module = mongoose.model('fix_values', fix_values_schema);
module.exports = fix_values_module;