const mongoose = require('mongoose');

const gali_disswar_bid_history_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    gameDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'gali_disswar_games'
    },
    game_name: {
        type: String,
        required: true,
    },
    pana: {
        type: String,
        required: true,
    },
    digits: {
        type: String,
        required: true,
    },
    winning_points: {
        type: Number,
        required: true,
    },
    points: {
        type: Number,
        required: true,
    },
    session: {
        type: String,
    },
    bid_tx_id: {
        type: String,
        required: true,
    },
    status: {
        type: Number,
        default: 1,
    },
    pay_status: {
        type: Number,
        required: true, // 1 = win , 2 = lose , 0 = pending , 3 = Cancel
    },
    close_result_token: {
        type: String,
    },


    bid_date: {
        type: Date,
        required: true,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const gali_disswar_bid_history_module = mongoose.model('gali_disswar_bid_history', gali_disswar_bid_history_schema);

module.exports = gali_disswar_bid_history_module;