const mongoose = require("mongoose");

const wingo_countdownSchema = new mongoose.Schema({
//   period: { type: Number, required: true },     // period ID
  type: {                                       // game type (wingo30, wingo60, etc.)
    type: String,
    enum: ["wingo30", "wingo60", "wingo180", "wingo300"], 
    required: true
  },
  duration: { type: Number, required: true },   // duration in seconds (30, 60, 180, 300)
  start_time: { type: Date, required: true },   // when game started
  end_time: { type: Date, required: true },     // when game ends (start + duration)
//   result: { type: String, default: null }       // result later
});

module.exports = mongoose.model("wingo_countdown", wingo_countdownSchema);
