const mongoose = require('mongoose');

const game_result_history_schema = new mongoose.Schema({
    gameDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'game',
        required: true,
    },
    open_number: {
        type: String,
    },
    close_number: {
        type: String,
    },
    open_decleare_status: {
        type: Number,
    },
    close_decleare_status: {
        type: Number,
    },
    open_result_token: {
        type: String,
    },
    close_result_token: {
        type: String,
    },


    result_date: {
        type: Date,
        required: true,
    },
    open_decleare_date: {
        type: Date,
    },
    close_decleare_date: {
        type: Date,
    },
});

const game_result_history_module = mongoose.model('game_result_history', game_result_history_schema);

module.exports = game_result_history_module;