const mongoose = require('mongoose');

const lottery_bid_history_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    lotteryDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'lottery',
        required: true,
    },
    lottery_name: {
        type: String,
        required: true,
    },
    ticket_num: {
        type: String,
        required: true,
    },
    points: {
        type: Number,
        required: true,
    },
    bid_tx_id: {
        type: Number,
        required: true,
    },
    txn_ref: {
        type: Number,
        required: true,
    },
    payby: {
        type: String,
        required: true,
    },
    status: {
        type: Number,
        required: true,
    },
    pay_status: {
        type: Number,
        required: true,
    },
    open_result_token: {
        type: String,
        required: true,
    },
    close_result_token: {
        type: String,
        required: true,
    },

    
    bid_date: {
        type: Date,
        required: true,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const lottery_bid_history_module = mongoose.model('lottery_bid_history', lottery_bid_history_schema);

module.exports = lottery_bid_history_module;