const mongoose = require('mongoose');

const lottery_schema = new mongoose.Schema({
    lottery_name: {
        type: String,
        required: true,
    },
    lottery_name_hindi: {
        type: String,
        required: true,
    },
    no_of_tickets: {
        type: Number,
        required: true,
    },
    start_from: {
        type: Number,
        required: true,
    },
    price: {
        type: Number,
        required: true,
    },
    first_prize: {
        type: Number,
        required: true,
    },
    second_prize: {
        type: Number,
        required: true,
    },
    third_prize: {
        type: Number,
        required: true,
    },
    lottery_image: {
        type: mongoose.Schema.Types.ObjectId,
        ref: "file"
    },
    status: {
        type: Number,
        required: true,
    },
    market_status: {
        type: Number,
        required: true,
    },
    market_off_day: {
        type: String, // Day Full Name
        required: true,
    },


    open_date: {
        type: Date,
        required: true,
    },
    open_date_sort: {
        type: Date,
        required: true,
    },
    close_date: {
        type: Date,
        required: true,
    },
});

const lottery_module = mongoose.model('lottery', lottery_schema);

module.exports = lottery_module;