const mongoose = require('mongoose');

const lottery_result_history_schema = new mongoose.Schema({
    lotteryDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'lottery',
        required: true,
    },
    ticket_number: {
        type: String,
        required: true,
    },
    ticket_decleare_status: {
        type: Number,
        required: true,
    },
    ticket_result_token: {
        type: String,
        required: true,
    },
    position: {
        type: String,
        required: true,
    },
    first_rank: {
        type: String,
        required: true,
    },
    second_rank: {
        type: String,
        required: true,
    },
    third_rank: {
        type: String,
        required: true,
    },
    
    
    result_date: {
        type: Date,
        required: true,
    },
    ticket_decleare_date: {
        type: Date,
        required: true,
    },
});

const lottery_result_history_module = mongoose.model('lottery_result_history', lottery_result_history_schema);

module.exports = lottery_result_history_module;