const mongoose = require('mongoose');

const lottery_tickets_schema = new mongoose.Schema({
    lotteryDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'lottery',
        required: true,
    },
    ticket_number: {
        type: Number,
        required: true,
    },
    status: {
        type: String,
        enum: ['available', 'unavailable'],
        required: true,
    },
});

const lottery_tickets_module = mongoose.model('lottery_tickets', lottery_tickets_schema);

module.exports = lottery_tickets_module;