const mongoose = require('mongoose')

const otpSchema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        require: true
    },
    //use for multiple references
    userDB_model: {
        type: String,
        required: true,
        enum: ['User', 'Admin']
    },
    otp: {
        type: Number,
        require: true
    },

    
    expiredAt: { type: Date, expires: 600 }  // 600 seconds = 10 minutes
})

const otp_module = mongoose.model('otp', otpSchema)

module.exports = otp_module