// models/PaymentGatewaySettings.js - Updated
const mongoose = require('mongoose');

const paymentGatewaySchema = new mongoose.Schema({
    gatewayId: {
        type: String,
        required: true,
        unique: true
    },
    name: {
        type: String,
        required: true
    },
    status: {
        type: Boolean,
        default: false
    },
    apiKey: String,
    clientId: String,
    secretKey: String,
    salt: String, // Added for DollarBazar
    baseUrl: String,
    minAmount: {
        type: Number,
        default: 0
    },
    maxAmount: {
        type: Number,
        default: 0
    },
    processingFee: {
        type: Number,
        default: 0
    },
    supportedMethods: [String],
    testMode: {
        type: Boolean,
        default: true
    },
    webhookUrl: String, // Added for webhooks
    insert_date: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true
});

module.exports = mongoose.model('PaymentGateway_settings', paymentGatewaySchema);

// models/PaymentSettings.js - New model for common settings
const paymentSettingsSchema = new mongoose.Schema({
    manualPaymentEnabled: {
        type: Boolean,
        default: true
    },
    userManualPaymentMode: {
        type: Number,
        default: 1 // 0=disable, 1=enable
    },
    userPgPaymentMode: {
        type: Number,
        default: 1 // 0=disable, 1=enable
    },
    quickDepositAmounts: [{
        type: Number,
        default: [100, 500, 1000, 2000, 5000]
    }],
    defaultGateway: {
        type: String,
        default: 'dollar_bazar'
    }
}, {
    timestamps: true
});

module.exports = mongoose.model('PaymentSettings', paymentSettingsSchema);