// models/PaymentGatewayLog.js
const mongoose = require('mongoose');

const paymentGatewayLogSchema = new mongoose.Schema({
    gatewayId: String,
    type: String, // 'connection_test', 'payment_request', 'payment_response', 'webhook'
    request: mongoose.Schema.Types.Mixed,
    response: mongoose.Schema.Types.Mixed,
    status: String, // 'success', 'failed', 'pending'
    amount: Number,
    transactionId: String,
    userId: mongoose.Schema.Types.ObjectId,
    errorMessage: String,
    insert_date: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true
});

module.exports = mongoose.model('PaymentGatewayLog', paymentGatewayLogSchema);