// models/qrcode_images.js
const mongoose = require('mongoose');

const qrcode_images_schema = new mongoose.Schema({
    qr_image: {
        type: String, // just store filename or path
        required: true,
    },
    qr_title: {
        type: String,
    },
    upi_id: {
        type: String,
        unique: true
    },
    description: {
        type: String,
    },
    status: {
        type: Number,
        default: 1,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
}, { timestamps: true });

const qrcode_images_module = mongoose.model('qrcode_images', qrcode_images_schema);
module.exports = qrcode_images_module;
