const mongoose = require('mongoose');

const refer_details_schema = new mongoose.Schema({
    refer_to: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    refer_by: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    refer_code: {
        type: String,
        required: true,
    },
    bonus: {
        type: Number,
        required: true,
    },

    
    updated_at: {
        type: Date,
        default: Date.now,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const refer_details_module = mongoose.model('refer_details', refer_details_schema);

module.exports = refer_details_module;