const mongoose = require('mongoose');

const roulette_bid_history_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    gameDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'game',
        required: true,
    },
    game_name: {
        type: String,
        required: true,
    },
    digits: {
        type: String,
        required: true,
    },
    points: {
        type: Number,
        required: true,
    },
    bid_tx_id: {
        type: String,
        required: true,
    },
    status: {
        type: Number,
        required: true,
    },
    pay_status: {
        type: Number,
        required: true,
    },
    result_token: {
        type: String,
        required: true,
    },


    bid_date: {
        type: Date,
        required: true,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const roulette_bid_history_module = mongoose.model('roulette_bid_history', roulette_bid_history_schema);

module.exports = roulette_bid_history_module;