const mongoose = require('mongoose');

const roulette_game_schema = new mongoose.Schema({
    gameDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'game',
        required: true,
    },
    game_name: {
        type: String,
        required: true,
    },
    status: {
        type: Number,
        required: true,
    },
    market_status: {
        type: Number,
        required: true,
    },


    open_time: {
        type: Date,
        required: true,
    },
    open_time_sort: {
        type: Date,
        required: true,
    },
    close_time: {
        type: Date,
        required: true,
    },
    close_time_sort: {
        type: Date,
        required: true,
    },
});

const roulette_game_module = mongoose.model('roulette_game', roulette_game_schema);

module.exports = roulette_game_module;