// In your model file (slider-images.model.js or similar)
const mongoose = require('mongoose');

const sliderImageSchema = new mongoose.Schema({
  filename: {
    type: String,
    required: true
  },
  originalName: {
    type: String,
    required: true
  },
  filePath: {
    type: String,
    required: true
  },
  size: {
    type: Number,
    required: true
  },
  mimetype: {
    type: String,
    required: true
  },
  redirect_url: {
    type: String,
    default: ""
  },
  status: {
    type: Number,
    default: 1 // 1 = active, 0 = inactive
  },
  createMkt: {
    type: Date,
    default: Date.now
  },
  updatedMkt: {
    type: Date,
    default: Date.now
  }
});

module.exports = mongoose.model('SliderImage', sliderImageSchema);