const mongoose = require('mongoose');

const starline_game_result_history_schema = new mongoose.Schema({
    gameDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'starline_games',
        required: true,
    },
    open_number: {
        type: String,
    },
    open_decleare_status: {
        type: Number,
    },
    open_result_token: {
        type: String,
    },

    result_date: {
        type: Date,
        required: true,
    },
    open_decleare_date: {
        type: Date,
    },
});

const starline_game_result_history_module = mongoose.model('starline_game_result_history', starline_game_result_history_schema);

module.exports = starline_game_result_history_module;