const mongoose = require('mongoose');

const user_address_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: "user",
        required: true,
    },
    stateDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: "state",
        required: true,
    },
    districtDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: "district",
        required: true,
    },
    flat_ploat_no: {
        type: Number,
        required: true,
    },
    address_lane_1: {
        type: String,
        required: true,
    },
    address_lane_2: {
        type: String,
        required: true,
    },
    area: {
        type: String,
        required: true,
    },
    pin_code: {
        type: Number,
        required: true,
    },


    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const user_address_module = mongoose.model('user_address', user_address_schema);

module.exports = user_address_module;