const mongoose = require('mongoose');

const user_bank_details_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
        unique: true, // one bank detail record per user
    },
    bank_name: {
        type: String,
        trim: true,
    },
    branch_address: {
        type: String,
        trim: true,
    },
    ac_holder_name: {
        type: String,
        trim: true,
    },
    ac_number: {
        type: String, // changed from Number → String
        required: true,
    },
    ifsc_code: {
        type: String,
        trim: true,
        required: true,
    },
    paytm_number: {
        type: String, // changed from Number → String
        default: "",
    },
    google_pay_number: {
        type: String, // changed from Number → String
        default: "",
    },
    phone_pay_number: {
        type: String, // changed from Number → String
        default: "",
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
});

// Optional: enforce uniqueness of account number + IFSC pair
// user_bank_details_schema.index({ ac_number: 1, ifsc_code: 1 }, { unique: true });

const user_bank_details_module = mongoose.model('user_bank_details', user_bank_details_schema);

module.exports = user_bank_details_module;
