const mongoose = require('mongoose');

const user_device_record_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    device_id: {
        type: String,
        required: true,
    },
    logout_status: {
        type: Number,
        default: 0,
    },
    security_pin_status: {
        type: Number,
        default: 0,
    },
},
timestamps = true);

const user_device_record_module = mongoose.model('user_device_record', user_device_record_schema);

module.exports = user_device_record_module;