const mongoose = require('mongoose');

const user_schema = new mongoose.Schema({
    unique_jwt_token: {
        type: String,
    },
    user_name: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        // required: true,
    },
    mobile: {
        type: Number,
    },
    profile_pic: {
        type: String,
        default: ''
    },
    password: {
        type: String,
        required: true,
    },
    security_pin: {
        type: Number,
        required: true,
    },
    // security_pin: {
    //     type: Number,
    //     required: true,
    // },
    wallet_balance: {
        type: Number,
        default: 0,
    },
    // hold_amount: {
    //     type: Number,
    //     default: 0,
    // },
    refer_code: {
        type: String,
    },
    my_code: {
        type: String,
        required: true,
    },
    is_agent: {
        type: Number,
        default: 0,
    },
    status: {
        type: Number,
        default: 1,
    },
    betting_status: {
        type: Number,
        default: 1,
    },
    notification_status: {  // other notification
        type: Number,
        default: 1,
    },
    other_notification_status: {  // other notification
        type: Number,
        default: 1,
    },
    main_game_notification_status: { // main game notification
        type: Number,
        default: 1,
    },
    gali_disswar_game_notification_status: { // gali disswar game notification
        type: Number,
        default: 1,
    },
    starline_game_notification_status: { // starline game notification
        type: Number,
        default: 1,
    },
    transfer_point_status: {
        type: Number,
        default: 1,
    },
    device_id: {
        type: String,
    },
    logout_status: {
        type: Number,
        default: 0,
    },
    avatar: {
        type: Number,
        default: 0
    },
    firebaseToken: {
        type: String,
        default: ''
    },
    last_seen_notification_at: {
        type: Date,
        default: null  // null = never opened bell
    },
    last_update: {
        type: Date,
        default: Date.now,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
    otp: {
  type: String,
  default: null
},
otp_expiry: {
  type: Date,
  default: null
}

}, {
    timestamps: true,
});

const user_module = mongoose.model('user', user_schema);

module.exports = user_module;
