const mongoose = require('mongoose');

const wallet_trans_archive_history_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    amount: {
        type: Number,
        required: true,
    },
    before_wallet: {
        type: Number,
    },
    transaction_type: {
        type: Number,
        required: true, // 1 on deposit/add fund    2 on withdraw fund
    },
    transaction_note: {
        type: String,
        required: true,
    },
    transfer_note: {
        type: String,
    },
    amount_status: {
        type: Number, // 1 = amount deposit by admin , 2 = amount withdraw by admin , 3 = user amount transfer to another user , 4 = user amount received from another user , 5 = bid placed , 6 = user welcome bonus , 7 = game deleted & amount refund , 8 = winning amount , 19 = user amount deposit , 
    },
    tx_request_number: {
        type: String,
        required: true,
    },
    txn_id: {
        type: String,
    },
    txn_ref: {
        type: String,
    },
    payby: {
        type: String,
    },
    admin_name: {
        type: String,
    },
    admin_type: {
        type: Number,
    },
    open_result_token: {
        type: String,
    },
    close_result_token: {
        type: String,
    },
    bid_tx_id: {
        type: String,
    },
    insert_date: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
});

const wallet_trans_archive_history_module = mongoose.model('wallet_trans_archive_history', wallet_trans_archive_history_schema);

module.exports = wallet_trans_archive_history_module;