const mongoose = require('mongoose');

const weekday_games_schema = new mongoose.Schema({
    gameDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'game',
        required: true,
    },
    name: {
        type: String,
        required: true,
    },
    week_name: {
        type: String,
        required: true,
    },
    weekday_status: {
        type: Number,
        required: true,
    },


    open_time: {
        type: Date,
    },
    open_time_sort: {
        type: Date,
        required: true,
    },
    close_time: {
        type: Date,
    },
});

const weekday_games_module = mongoose.model('weekday_games', weekday_games_schema);

module.exports = weekday_games_module;