const mongoose = require('mongoose');

const withdraw_fund_request_schema = new mongoose.Schema({
    userDB_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user',
        required: true,
    },
    amount: {
        type: Number,
        required: true,
    },
    tx_request_number: {
        type: String,
        required: true,
    },
    bankReference: {
        type: String,
        // required: true,
    },
    fund_status: {
        type: Number,
        default: 0, // 0 = pending , 1 = approve , 2 = failed/rejected, 3 = Pending
    },
    payment_method: {
        type: Number, // 0 = Manual withdraw , 7 = dollar bazar , 8 = proton pay
        default : 0 // default set 0 for manual then after update while approve or auto withdraw time this auto update
    },
    withdraw_type: {
        type: Number,
        // required: true // 0 = manual , 1 = Payment Gateway
    },
    bank_name: {
        type: String,
    },
    branch_address: {
        type: String,
    },
    ac_holder_name: {
        type: String,
    },
    ac_number: {
        type: Number,
    },
    ifsc_code: {
        type: String,
    },
    // paytm_number: {
    //     type: Number,
    // },
    // google_pay_number: {
    //     type: Number,
    // },
    // phone_pay_number: {
    //     type: Number,
    // },
    // fund_payment_receipt: {
    //     type: mongoose.Schema.Types.ObjectId,
    //     ref: 'file',
    // },
    // fund_payment_receipt: {
    //     type: String, // Changed from ObjectId to String
    // },
    remark: {
        type: String,
    },


    insert_date: {
        type: Date,
        default: Date.now,
    },
});

const withdraw_fund_request_module = mongoose.model('withdraw_fund_request', withdraw_fund_request_schema);

module.exports = withdraw_fund_request_module;