const express = require("express");
const router = express.Router();

const { 
    addMoneyViaGateway, 
    getAvailablePaymentGateways,
    refreshPGTransactionStatus 
} = require("../controllers/payment.controller");
const { 
    dollarbazarWebhook, 
    protonpayWebhook 
} = require("../controllers/webhook.controller");

// Payment endpoints
router.post("/api/add-money/payment-gateway", addMoneyViaGateway);// payment gateway route to add money
router.post("/api/get-available-gateways", getAvailablePaymentGateways);
router.post("/pg/refresh-pg-transaction", refreshPGTransactionStatus);

// Webhook endpoints
// router.post("/webhook/dollarbazar", express.json(), dollarbazarWebhook);
// router.post("/webhook/protonpay", express.json(), protonpayWebhook);

module.exports = router;






// // routes/payment.routes.js
// const express = require("express");
// const router = express.Router();

// const { addMoneyViaGateway, refreshPGTransactionStatus, } = require("../controllers/payment.controller");
// const { dollarbazarWebhook, protonpayWebhook } = require("../controllers/webhook.controller");

// // const {} = require('../services/dollarbazar.service')

// // Public/Authenticated endpoints
// router.post("/api/add-money/payment-gateway", addMoneyViaGateway);
// // router.get("/deposit/status/:orderId", getDepositStatus);

// // Webhook endpoint (no auth - reachable by gateway)
// router.post("/webhook/dollarbazar", express.json(), dollarbazarWebhook);
// router.post("/webhook/protonpay", express.json(), protonpayWebhook);

// router.post("/api/get-dollar-bazar-pg-token", dollarbazarWebhook);



// router.post('/pg/refresh-pg-transaction', refreshPGTransactionStatus);


// module.exports = router;
