const debug = require("debug")("test");
let Players = []

function AddPlayer(data) {
  let PlayerIndex = Players.findIndex(player => player.playerId == data.playerId);
  if(PlayerIndex!=-1){
    Players[PlayerIndex] = data;
  }else{
    Players.push(data)
  }
  // debug("new player add");
  // debug(data)
}
function GetAllPlayers() {
  return Players;
}
function RemovePlayer(socketId) {

  for (let i = 0; i < Players.length; i++) {
    if (Players[i].socketId === socketId) {
      Players.splice(i, 1);
      return;
    }
    //debug("player not found");
  }
}
function RemovePlayer2(playerId) {

  for (let i = 0; i < Players.length; i++) {
    if (Players[i].playerId === playerId) {
      Players.splice(i, 1);
      return;
    }
    //debug("player not found");
  }
}
function GetPlayerData(socketId) {
  for (let i = 0; i < Players.length; i++) {
    if (Players[i].socketId === socketId) {
      console.log("player found", Players[i]);
      return Players[i];
    }
  }
  return null;
}
function GetPlayerDataBYPlayerId(playerId) {
  for (let i = 0; i < Players.length; i++) {
    if (Players[i].playerId === playerId) {
      return Players[i];
    }
  }
  return {};
}

function GetPlayerDataBYPlayerId2(playerId, roomId = null) {
  const playerIndex = roomId
    ? Players.findIndex(player => player.playerId === playerId && player.roomId === roomId)
    : Players.findIndex(player => player.playerId === playerId);
  if (playerIndex >= 0) {
    return Players[playerIndex];
  }
  return {};
}

function PlayerLength() {
  return Players.length;
}

function updateRound(socketId, roomId = null) {
  const playerIndex = roomId
    ? Players.findIndex(player => player.socketId === socketId && player.roomId === roomId)
    : Players.findIndex(player => player.socketId === socketId);
  if (playerIndex >= 0) {
    Players[playerIndex].play_round++;
  }
}
function updateRoundDT(socketId, roomId = null) {
  const playerIndex = roomId
    ? Players.findIndex(player => player.playerId === socketId && player.roomId === roomId)
    : Players.findIndex(player => player.playerId === socketId);
  if (playerIndex >= 0) {
    Players[playerIndex].play_round++;
  }
}
async function updateWinRound(socketId, amount) {
  const playerIndex = Players.findIndex(player => player.socketId === socketId);
  if (playerIndex >= 0) {
    Players[playerIndex].chipwon += amount
    Players[playerIndex].win += amount;
    if (amount > 0) {
      Players[playerIndex].roundWon++;
    }
  }
}
function updateWinRoundDT(socketId, amount) {
  const playerIndex = Players.findIndex(player => player.playerId === socketId);
  if (playerIndex >= 0) {
    Players[playerIndex].chipwon += amount
    Players[playerIndex].win += amount;
    if (amount > 0) {
      Players[playerIndex].roundWon++;
    }
  }
}
function updateLossRound(socketId, amount) {
  for (let i = 0; i < Players.length; i++) {
    if (Players[i].socketId === socketId) {
      Players[i].loss += amount;
      // if (amount > 0) {
      //   Players[i].roundWon++;
      // }
    }
  }
}

function updatePosition(playerId, position, roomId = null) {
  const playerIndex = Players.findIndex(player => player.playerId === playerId);
  let res = false;
  if (playerIndex !== -1) {
    if (Players[playerIndex].position !== position) {
      Players[playerIndex].position = position;
      res = true;
    }
    if (roomId && Players[playerIndex].roomId !== roomId) {
      Players[playerIndex].roomId = roomId;
      res = false;
    }
  }
  return res;
}
function updatePositionPoker(playerId, position, roomId = null) {
  let playerIndex = -1;
  if (roomId != null) {
    playerIndex =  Players.findIndex(player => player.roomId === roomId && player.playerId === playerId);
  }
  playerIndex =  Players.findIndex(player => player.playerId === playerId);

  let res = false;
  if (playerIndex !== -1) {
    if (Players[playerIndex].position !== position) {
      Players[playerIndex].position = position;
      // if(Players[playerIndex].position == 0 && Players[playerIndex]?.turn && Players[playerIndex].gameId == 6){
      //   Players[playerIndex].turn = false;
      // }
      res = true;
    }
  }
  return res;
}

function ABEmptySeats(roomId, position = null) {
  const allSeats = [1, 2, 3, 4, 5];
	const emptySeats = [];
	for (let seat of allSeats) {
		let isSeatAvailable = false;
		for (let player of Players) {
			if (position != null && position === seat && seat === player.position && roomId === player.roomId) {
				isSeatAvailable = true;
				break;
			} else if (position === null && seat === player.position && roomId === player.roomId) {
				isSeatAvailable = true;
				break;
			}
		}
		if (position !== null && !isSeatAvailable && seat === position) {
			emptySeats.push(seat);
		} else if (position === null && !isSeatAvailable) {
			emptySeats.push(seat);
		}
	}
	return emptySeats;
}
function updateRoomId(playerId, roomId) {
  const playerIndex = Players.findIndex(player => player.playerId === playerId);
  if (playerIndex >= 0) {
    Players[playerIndex].roomId = roomId;
  }
}

function getSeatedUsers(roomId) {
  let players = [];
  for (let i = 0; i < Players.length; i++) {
    // console.log(Players[i] , "--", "roomId");
    if (Players[i].position != 0 && Players[i].roomId == roomId && Players[i].turn == true) {
      players.push(Players[i])
    }
  }
  // console.log(players,"[]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]][[[[[[[[[[[[[[[[[[]]]]]]]]]]]][[][][]");
  return players;
}

function getUsersByGameId(gameId, roomId = null) {
  if (roomId != null) {
    return Players.filter(player => player.roomId === roomId && player.gameId === gameId);
  }
  return Players.filter(player => player.gameId === gameId);
}
function updateBetBalance(playerId,chip) {
  const playerIndex = Players.findIndex(player => player.playerId === playerId);
  if (playerIndex >= 0 && Players[playerIndex].balance >= chip) {
    Players[playerIndex].balance -= chip;
    }
  return  Players[playerIndex]
}
function updateWinBalance(playerId,chip) {
  const playerIndex = Players.findIndex(player => player.playerId === playerId);
  if (playerIndex >= 0 ) {
    Players[playerIndex].balance += chip;
    }
  return  Players[playerIndex]
}

module.exports.updateLossRound = updateLossRound;
module.exports.AddPlayer = AddPlayer;
module.exports.RemovePlayer = RemovePlayer;
module.exports.RemovePlayer2 = RemovePlayer2;
module.exports.GetPlayerData = GetPlayerData;
module.exports.GetPlayerDataBYPlayerId = GetPlayerDataBYPlayerId;
module.exports.GetPlayerDataBYPlayerId2 = GetPlayerDataBYPlayerId2;
module.exports.GetAllPlayers = GetAllPlayers;
module.exports.PlayerLength = PlayerLength;
module.exports.updateRound = updateRound;
module.exports.updateRoundDT = updateRoundDT;
module.exports.updateWinRound = updateWinRound
module.exports.updateWinRoundDT = updateWinRoundDT
module.exports.updatePosition = updatePosition
module.exports.updatePositionPoker = updatePositionPoker
module.exports.Players = Players;
module.exports.getSeatedUsers = getSeatedUsers;
module.exports.getUsersByGameId = getUsersByGameId;
module.exports.updateRoomId = updateRoomId;
module.exports.ABEmptySeats = ABEmptySeats;
module.exports.updateBetBalance = updateBetBalance;
module.exports.updateWinBalance = updateWinBalance;