function uniqRandom(length = 7) {
    // Validate length
    if (length < 2) {
      throw new Error("Length must be at least 2");
    }
  
    const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const numLen = length - 2;
  
    // Generate 2 random letters
    let randStr = "";
    for (let i = 0; i < 2; i++) {
      const randomIndex = Math.floor(Math.random() * characters.length);
      randStr += characters[randomIndex];
    }
  
    // Generate random digits
    let digits = "";
    for (let i = 0; i < numLen; i++) {
      digits += Math.floor(Math.random() * 10);
    }
  
    return randStr + digits;
  }
  
  module.exports = { uniqRandom };