/**
 * Convert IST Date to UTC Date for MongoDB storage
 * @param {Date} istDate - A Date object in IST timezone
 * @returns {Date} - Converted UTC Date object
 */
function convertISTDateToMongoDate(istDate) {
    if (!(istDate instanceof Date)) return null;
    // Create moment with IST and convert to UTC
    return moment_timeZone.tz(moment_timeZone(istDate).format('YYYY-MM-DD HH:mm:ss'), 'Asia/Kolkata').toDate();
}

module.exports = convertISTDateToMongoDate