const moment_timeZone = require('moment-timezone');

/**
 * Convert MongoDB UTC Date to IST Date object
 * @param {Date} mongoDate - Date stored in MongoDB (UTC)
 * @returns {Date} - Date object in IST timezone
 */
function convertMongoDateToIST(mongoDate) {
    if (!(mongoDate instanceof Date)) return null;
    return moment_timeZone(mongoDate).tz('Asia/Kolkata').toDate();
}

module.exports = convertMongoDateToIST