async function deductUserWallet(open_result_token) {
    try {
        const WalletTransHistory = mongoose.model('wallet_trans_history');
        const User = mongoose.model('user');

        const result = await WalletTransHistory.find({ open_result_token });

        for (const rs of result) {
            const userId = rs.userDB_id;
            const amount = rs.amount;
            const transactionId = rs.transaction_id;

            await User.updateOne(
                { _id: userId },
                { $inc: { wallet_balance: -amount } }
            );

            await WalletTransHistory.deleteOne({
                userDB_id: userId,
                transaction_id: transactionId,
            });
        }
    } catch (error) {
        console.error('Error in deductUserWallet:', error);
        throw error;
    }
}
