const moment_timeZone = require('moment-timezone');

/**
 * Format ISO Date (string or Date object) to "DD-MM-YYYY" in IST timezone
 * @param {string|Date} isoDate - ISO string or Date object
 * @returns {string} - Formatted date string in DD-MM-YYYY (IST)
 */
function formatDateToDDMMYYYY(isoDate) {
  if (!isoDate) return '';

  const momentInput = isoDate instanceof Date ? isoDate : new Date(isoDate);
  if (isNaN(momentInput.getTime())) return ''; // Invalid date check

  const istMoment = moment_timeZone(momentInput).tz('Asia/Kolkata');
  return istMoment.format('DD-MM-YYYY');
}

/**
 * Convert "DD:MM:YYYY" string to ISO string (UTC) based on IST timezone
 * @param {string} ddmmyyyy - Date string in "DD:MM:YYYY" format
 * @returns {string} ISO string in UTC
 */
function convertToISODate(ddmmyyyy) {
  if (!ddmmyyyy || !ddmmyyyy.includes(':')) return '';

  const [day, month, year] = ddmmyyyy.split(':');

  // Create IST-based moment
  const istMoment = moment_timeZone.tz(`${day}-${month}-${year}`, 'DD-MM-YYYY', 'Asia/Kolkata');

  // Convert to ISO UTC string
  return istMoment.toDate().toISOString(); // Returns UTC-based ISO string
}

/**
 * Get weekday name in IST (e.g. "Monday" or "Mon")
 * @param {Date} date - JS Date object (defaults to now)
 * @param {boolean} isHalf - If true, returns short name like "Mon"
 * @returns {string} Weekday name in IST
 */
function getWeekdayNameInIST(date = new Date(), isHalf = false) {
  const istMoment = moment_timeZone(date).tz('Asia/Kolkata');
  return istMoment.format(isHalf ? 'ddd' : 'dddd');
}

module.exports = {
  formatDateToDDMMYYYY,
  convertToISODate,
  getWeekdayNameInIST
};










// import moment_timeZone from 'moment-timezone';


// /**
//  * Format ISO Date (string or Date object) to "DD-MM-YYYY" in IST timezone
//  * @param {string|Date} isoDate - ISO string or Date object
//  * @returns {string} - Formatted date string in DD-MM-YYYY (IST)
//  */
// export function formatDateToDDMMYYYY(isoDate) {
//   if (!isoDate) return '';

//   const momentInput = isoDate instanceof Date ? isoDate : new Date(isoDate);
//   if (isNaN(momentInput.getTime())) return ''; // Invalid date check

//   const istMoment = moment_timeZone(momentInput).tz('Asia/Kolkata');
//   return istMoment.format('DD-MM-YYYY');
// }


// /**
//  * Convert "DD:MM:YYYY" string to ISO string (UTC) based on IST timezone
//  * @param {string} ddmmyyyy - Date string in "DD:MM:YYYY" format
//  * @returns {string} ISO string in UTC
//  */
// export function convertToISODate(ddmmyyyy) {
//   if (!ddmmyyyy || !ddmmyyyy.includes(':')) return '';

//   const [day, month, year] = ddmmyyyy.split(':');

//   // Create IST-based moment
//   const istMoment = moment_timeZone.tz(`${day}-${month}-${year}`, 'DD-MM-YYYY', 'Asia/Kolkata');

//   // Convert to ISO UTC string
//   return istMoment.toDate().toISOString(); // Returns UTC-based ISO string
// }

// /**
//  * Get weekday name in IST (e.g. "Monday" or "Mon")
//  * @param {Date} date - JS Date object (defaults to now)
//  * @param {boolean} isHalf - If true, returns short name like "Mon"
//  * @returns {string} Weekday name in IST
//  */
// export function getWeekdayNameInIST(date = new Date(), isHalf = false) {
//   const istMoment = moment_timeZone(date).tz('Asia/Kolkata');
//   return istMoment.format(isHalf ? 'ddd' : 'dddd');
// }
