// utils/logger.js
const winston = require("winston");
require("winston-daily-rotate-file");
const path = require("path");

// Log folder
const logDir = path.join(__dirname, "..", "logs");

const transport = new winston.transports.DailyRotateFile({
    dirname: logDir,
    filename: "server-%DATE%.log",
    datePattern: "YYYY-MM-DD",
    zippedArchive: false,
    maxSize: "20m",
    maxFiles: "30d"
});

const logger = winston.createLogger({
    level: "info",
    format: winston.format.combine(
        winston.format.timestamp({ format: "YYYY-MM-DD HH:mm:ss" }),
        winston.format.json()
    ),
    transports: [
        transport,
        new winston.transports.Console()
    ]
});

module.exports = logger;
