// function parseCustomDate(dateStr) {
//     console.log( new Date(dateStr), {})
//     const indiaTime = new Date(dateStr.toLocaleString("en-US", { timeZone: "Asia/Kolkata" }));
//     console.log( "indiaTime", indiaTime)

//     const monthMap = {
//         Jan: 0, Feb: 1, Mar: 2, Apr: 3, May: 4, Jun: 5,
//         Jul: 6, Aug: 7, Sep: 8, Oct: 9, Nov: 10, Dec: 11
//     };

//     const parts = dateStr.split('-'); // ['2025', 'Jul', '11']
//     if (parts.length !== 3) return null;

//     const year = parseInt(parts[0], 10);
//     const month = monthMap[parts[1]];
//     const day = parseInt(parts[2], 10);

//     if (isNaN(year) || isNaN(month) || isNaN(day)) return null;

//     return new Date(year, month, day);
// }




// function parseCustomDate(dateString) {
//   const months = {
//     'Jan': '01', 'Feb': '02', 'Mar': '03', 'Apr': '04',
//     'May': '05', 'Jun': '06', 'Jul': '07', 'Aug': '08',
//     'Sep': '09', 'Oct': '10', 'Nov': '11', 'Dec': '12'
//   };

//   const parts = dateString.split('-');
//   const year = parts[0];
//   const month = months[parts[1]];
//   const day = parts[2];

//   // Construct as UTC midnight
//   return new Date(`${year}-${month}-${day}T00:00:00Z`);
// }

// const istDate = createISTDate("2025-Sep-30");
// console.log("IST Date:", istDate.toLocaleString("en-IN", { timeZone: "Asia/Kolkata" }));
// console.log("UTC Date:", istDate.toUTCString());
// console.log("ISO Date:", istDate.toISOString());


// module.exports = parseCustomDate


function parseCustomDate(dateStr) {
    if (!dateStr || typeof dateStr !== 'string') return null;

    const monthMap = {
        'Jan': 0, 'Feb': 1, 'Mar': 2, 'Apr': 3, 'May': 4, 'Jun': 5,
        'Jul': 6, 'Aug': 7, 'Sep': 8, 'Sept': 8, 'Oct': 9, 'Nov': 10, 'Dec': 11
    };

    // Remove extra spaces and trim
    const cleanedDateStr = dateStr.replace(/\s+/g, ' ').trim();

    console.log(`🔍 Parsing date: "${cleanedDateStr}"`);

    // Format 1: "30 Sept 2025" (DD MMM YYYY) - from apiGetCurrentDate
    if (cleanedDateStr.match(/^\d{1,2}\s+[A-Za-z]+\s+\d{4}$/)) {
        const parts = cleanedDateStr.split(' ');
        const day = parseInt(parts[0], 10);
        const monthName = parts[1];
        const year = parseInt(parts[2], 10);

        const month = monthMap[monthName];

        if (!isNaN(day) && month !== undefined && !isNaN(year)) {
            const date = new Date(year, month, day);
            console.log(`✅ Parsed as DD MMM YYYY: ${date}`);
            return date;
        }
    }

    // Format 2: "2025-Sept-30" (YYYY-MMM-DD) - your original format
    if (cleanedDateStr.includes('-')) {
        const parts = cleanedDateStr.split('-');
        if (parts.length === 3) {
            // Check if first part is year (4 digits)
            if (parts[0].length === 4) {
                const year = parseInt(parts[0], 10);
                const monthName = parts[1];
                const day = parseInt(parts[2], 10);

                const month = monthMap[monthName];

                if (!isNaN(year) && month !== undefined && !isNaN(day)) {
                    const date = new Date(year, month, day);
                    console.log(`✅ Parsed as YYYY-MMM-DD: ${date}`);
                    return date;
                }
            }
        }
    }

    console.log(`❌ Could not parse date: "${cleanedDateStr}"`);
    return null;
}

module.exports = parseCustomDate;