const { getUserRandomToken } = require("../helper/helper_functions");
const user_module = require("../model/user_module");
const wallet_trans_history_module = require("../model/wallet_trans_history_module");
const Random_number = require("./Random_number");

module.exports = {
    updateUserBalance: async (userDB_id, amount, message, closeResultToken, bidTxId) => {
        try {
            await user_module.findByIdAndUpdate(userDB_id, { $inc: { balance: amount } }, { new: true });

            const random = getUserRandomToken();

            await wallet_trans_history_module.create({
                userDB_id: userDB_id,
                amount: amount,
                transaction_type: 1,
                transaction_note: message,

                amount_status: 8,
                tx_request_number: random,


                close_result_token: closeResultToken,
                bid_tx_id: bidTxId,
                message: message,

            })
        } catch (error) {
            console.log("error in updateUserBalance", error);
            throw new Error(error);
        }
    }
}